<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Admin extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Lelang_model');
        $this->load->helper(array('url', 'form', 'text'));
        $this->load->library('session');

        // Cek login untuk semua fungsi kecuali login
        if (!in_array($this->router->method, ['login', 'logout']) && !$this->session->userdata('admin_logged')) {
            redirect('admin/login');
        }
    }

    public function login()
    {
        if ($this->input->method() === 'post') {
            $username = $this->input->post('username');
            $password = $this->input->post('password');
            $admin = $this->Lelang_model->get_admin($username);

            if (!$admin) {
                $this->session->set_flashdata('error', 'Username tidak ditemukan');
            } else {
                // Gunakan trim() agar tidak ada spasi/enter
                if (trim($password) !== trim($admin['password'])) {
                    $this->session->set_flashdata('error', 'Password salah');
                } else {
                    $this->session->set_userdata('admin_logged', true);
                    redirect('admin/dashboard');
                    return;
                }
            }
        }

        $this->load->view('admin/login');
    }


    public function logout()
    {
        $this->session->sess_destroy();
        redirect('admin/login');
    }

    public function dashboard()
    {
        $data['lelang'] = $this->Lelang_model->get_all();
        $this->load->view('admin/dashboard', $data);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $foto = '';
            if (!empty($_FILES['foto']['name'])) {
                $foto = time() . '_' . $_FILES['foto']['name'];
                move_uploaded_file($_FILES['foto']['tmp_name'], './uploads/' . $foto);
            }

            $this->Lelang_model->insert([
                'foto' => $foto,
                'nama_debitur' => $this->input->post('nama_debitur'),
                'deskripsi' => $this->input->post('deskripsi'),
                'contact_rm' => $this->input->post('contact_rm'),
                'kelolaan' => $this->input->post('kelolaan'),
                'nilai_limit' => $this->input->post('nilai_limit'),
            ]);
            redirect('admin/dashboard');
        }
        $this->load->view('admin/form');
    }

    public function edit($id)
    {
        $data['edit'] = true;
        $data['data'] = $this->Lelang_model->get_by_id($id);

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $update_data = [
                'nama_debitur' => $this->input->post('nama_debitur'),
                'deskripsi' => $this->input->post('deskripsi'),
                'contact_rm' => $this->input->post('contact_rm'),
                'kelolaan' => $this->input->post('kelolaan'),
                'nilai_limit' => $this->input->post('nilai_limit'),
            ];

            if (!empty($_FILES['foto']['name'])) {
                $foto = time() . '_' . $_FILES['foto']['name'];
                move_uploaded_file($_FILES['foto']['tmp_name'], './uploads/' . $foto);
                $update_data['foto'] = $foto;
            }

            $this->Lelang_model->update($id, $update_data);
            redirect('admin/dashboard');
        }

        $this->load->view('admin/form', $data);
    }

    public function delete($id)
    {
        $this->Lelang_model->delete($id);
        redirect('admin/dashboard');
    }
}
