<?php
class Lelang_model extends CI_Model
{

    public function get_all()
    {
        return $this->db->get('lelang')->result_array();
    }

    public function get_by_id($id)
    {
        return $this->db->get_where('lelang', ['id' => $id])->row_array();
    }

    public function insert($data)
    {
        return $this->db->insert('lelang', $data);
    }

    public function delete($id)
    {
        return $this->db->delete('lelang', ['id' => $id]);
    }

    public function update($id, $data)
    {
        return $this->db->update('lelang', $data, ['id' => $id]);
    }

    public function get_admin($username)
    {
        return $this->db->get_where('admin', ['username' => $username])->row_array();
    }

    public function get_by_kelolaan($kelolaan)
    {
        return $this->db->get_where('lelang', ['kelolaan' => $kelolaan])->result_array();
    }
}
