<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Dashboard Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(to right, #e6f0ff, #ffffff);
            font-family: 'Segoe UI', sans-serif;
        }

        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.05);
        }

        h2 {
            color: #003366;
        }

        .btn {
            border-radius: 8px;
        }

        th {
            background-color: #f1f5f9;
            color: #333;
        }

        td img {
            border-radius: 8px;
        }

        @media (max-width: 576px) {
            h2 {
                font-size: 1.5rem;
                text-align: center;
            }

            .btn {
                margin-bottom: 10px;
            }

            td img {
                width: 80px;
                height: auto;
            }

            .table-responsive {
                font-size: 0.9rem;
            }
        }
    </style>
</head>

<body>
    <div class="container my-5">
        <h2 class="mb-4 text-center">📋 Dashboard Admin</h2>

        <div class="text-end mb-3">
            <a href="<?= base_url('admin/create') ?>" class="btn btn-success">➕ Tambah Aset</a>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>Foto</th>
                        <th>Nama Debitur</th>
                        <th>Deskripsi</th>
                        <th>Contact RM</th>
                        <th>Kelolaan</th>
                        <th>Nilai Limit</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($lelang as $item): ?>
                        <tr>
                            <td><img src="<?= base_url('uploads/' . $item['foto']) ?>" width="100" alt="Foto Aset"></td>
                            <td><?= $item['nama_debitur'] ?></td>
                            <td><?= word_limiter($item['deskripsi'], 10) ?></td>
                            <td><?= $item['contact_rm'] ?></td>
                            <td><?= $item['kelolaan'] ?></td>
                            <td>Rp <?= number_format($item['nilai_limit'], 0, ',', '.') ?></td>
                            <td>
                                <div class="d-grid gap-2 d-md-block">
                                    <a href="<?= base_url('admin/edit/' . $item['id']) ?>" class="btn btn-warning btn-sm">✏️ Edit</a>
                                    <a href="<?= base_url('admin/delete/' . $item['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus aset ini?')">🗑️ Hapus</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="text-end mt-4">
            <a href="<?= base_url('admin/logout') ?>" class="btn btn-outline-secondary">🔓 Logout</a>
        </div>
    </div>
</body>

</html>