<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title><?= isset($edit) ? 'Edit' : 'Tambah' ?> Aset</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(to right, #e6f0ff, #ffffff);
            font-family: 'Segoe UI', sans-serif;
        }

        .form-container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.05);
        }

        h2 {
            color: #003366;
            margin-bottom: 30px;
        }

        label {
            font-weight: 500;
            color: #003366;
        }

        .btn-primary {
            background-color: #003366;
            border-color: #003366;
        }

        .btn-secondary {
            background-color: #f0f0f0;
            color: #003366;
            border: 1px solid #003366;
        }

        img.preview {
            max-width: 150px;
            margin-top: 10px;
            border-radius: 8px;
        }

        @media (max-width: 576px) {
            h2 {
                font-size: 1.5rem;
                text-align: center;
            }

            .btn {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="container py-5">
        <div class="form-container mx-auto" style="max-width: 600px;">
            <h2 class="text-center"><?= isset($edit) ? 'Edit' : 'Tambah' ?> Aset</h2>

            <form method="post" enctype="multipart/form-data" onsubmit="return validateLimit()">
                <div class="mb-3">
                    <label>Nama Debitur</label>
                    <input type="text" name="nama_debitur" class="form-control" value="<?= $data['nama_debitur'] ?? '' ?>" required>
                </div>

                <div class="mb-3">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="3"><?= $data['deskripsi'] ?? '' ?></textarea>
                </div>

                <div class="mb-3">
                    <label>Contact</label>
                    <input type="text" name="contact_rm" class="form-control" value="<?= $data['contact_rm'] ?? '' ?>">
                </div>

                <div class="mb-3">
                    <label>Nilai Limit (dalam Rupiah)</label>
                    <input type="number" name="nilai_limit" class="form-control" placeholder="Contoh: 250000000" value="<?= $data['nilai_limit'] ?? '' ?>" required id="limit">
                    <div class="form-text">Minimal Rp 1.000.000</div>
                </div>

                <div class="mb-3">
                    <label>Kelolaan</label>
                    <select name="kelolaan" class="form-control" required>
                        <option value="">-- Pilih Kelolaan --</option>
                        <?php
                        $options = ['Sudiarto', 'Mranggen', 'Kedungmundu', 'Majapahit', 'Tlogosari'];
                        foreach ($options as $opt):
                            $selected = (isset($data['kelolaan']) && $data['kelolaan'] === $opt) ? 'selected' : '';
                        ?>
                            <option value="<?= $opt ?>" <?= $selected ?>><?= $opt ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label>Foto <?= isset($edit) ? '(biarkan kosong jika tidak diganti)' : '' ?></label>
                    <input type="file" name="foto" class="form-control" accept="image/*" onchange="previewImage(event)">
                    <img id="imagePreview" class="preview d-none">
                    <?php if (isset($edit) && $data['foto']): ?>
                        <p class="mt-2"><img src="<?= base_url('uploads/' . $data['foto']) ?>" alt="Foto" width="120" class="preview"></p>
                    <?php endif; ?>
                </div>

                <div class="d-grid gap-2 d-md-flex justify-content-md-start">
                    <button type="submit" class="btn btn-primary"><?= isset($edit) ? 'Update' : 'Simpan' ?></button>
                    <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-secondary">Kembali</a>
                </div>
            </form>
        </div>
    </div>

    <script>
        function previewImage(event) {
            const reader = new FileReader();
            reader.onload = function() {
                const output = document.getElementById('imagePreview');
                output.src = reader.result;
                output.classList.remove('d-none');
            }
            reader.readAsDataURL(event.target.files[0]);
        }

        function validateLimit() {
            const limit = document.getElementById('limit').value;
            if (limit < 1000000) {
                alert("Nilai limit minimal Rp 1.000.000");
                return false;
            }
            return true;
        }
    </script>
</body>

</html>