<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(135deg, #f0f4f8, #d9e2ec);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', sans-serif;
        }

        .login-box {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
        }

        h2 {
            font-size: 1.8rem;
            margin-bottom: 25px;
            color: #003366;
            text-align: center;
        }

        .form-label {
            font-weight: 500;
        }

        .btn-primary {
            background-color: #0061a8;
            border: none;
        }

        .btn-primary:hover {
            background-color: #004d85;
        }

        .btn-outline-secondary {
            border-color: #aaa;
            color: #555;
        }

        @media (max-width: 576px) {
            h2 {
                font-size: 1.5rem;
            }

            .btn {
                width: 100%;
                margin-bottom: 10px;
            }

            .d-md-flex {
                flex-direction: column;
            }
        }
    </style>
</head>

<body>
    <div class="login-box">
        <h2>Login Admin</h2>
        <form method="post">
            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger"><?= $this->session->flashdata('error') ?></div>
            <?php endif; ?>

            <div class="mb-3">
                <label for="username" class="form-label">👤 Username</label>
                <input type="text" id="username" name="username" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">🔒 Password</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>

            <div class="d-grid gap-2 d-md-flex justify-content-md-start">
                <button class="btn btn-primary" type="submit">Login</button>
                <a href="<?= base_url('index.php') ?>" class="btn btn-outline-secondary">Halaman Utama</a>
            </div>
        </form>
    </div>
</body>

</html>