<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ASET AGUNAN BRI SEMARANG BRIGJEN SUDIARTO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        /* Latar belakang batik dengan opacity 55% */
        body {
            position: relative;
            min-height: 100vh;
            z-index: 0;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('<?= base_url("uploads/batik.jpg") ?>') no-repeat center center fixed;
            background-size: cover;
            opacity: 0.05;
            z-index: -1;
        }

        .navbar-custom {
            background-color: #3494edff;
        }

        .navbar-custom .navbar-brand,
        .navbar-custom .nav-link {
            color: white;
        }

        .card {
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }

        .card-img-top {
            height: 200px;
            object-fit: cover;
        }

        .filter-select {
            max-width: 400px;
            margin: auto;
        }

        @media (max-width: 576px) {
            h1 {
                font-size: 1.3rem;
            }

            .card-body h5 {
                font-size: 1.1rem;
            }

            .card-body p {
                font-size: 0.95rem;
            }

            .text-end {
                text-align: center !important;
            }
        }
    </style>
</head>

<body>

    <!-- Header -->
    <nav class="navbar navbar-custom sticky-top">
        <div class="container-fluid d-flex justify-content-between align-items-center px-4">
            <span class="navbar-brand fw-bold d-flex align-items-center gap-2">
                <img src="<?= base_url('uploads/bri-removebg-preview.png') ?>" alt="Logo BRI" height="32">
                BO Brigjen Sudiarto
            </span>
            <a href="<?= base_url('admin/login') ?>" class="btn btn-outline-light btn-sm">🔑Login</a>
        </div>
    </nav>

    <!-- Filter Kelolaan -->
    <div class="container py-4">
        <form method="get" class="mb-4">
            <div class="filter-select">
                <select name="kelolaan" class="form-select shadow-sm" onchange="this.form.submit()">
                    <option value="">🔍 Semua Kelolaan</option>
                    <option value="sudiarto" <?= ($this->input->get('kelolaan') == 'sudiarto') ? 'selected' : '' ?>>Sudiarto</option>
                    <option value="mranggen" <?= ($this->input->get('kelolaan') == 'mranggen') ? 'selected' : '' ?>>Mranggen</option>
                    <option value="kedungmundu" <?= ($this->input->get('kelolaan') == 'kedungmundu') ? 'selected' : '' ?>>Kedungmundu</option>
                    <option value="majapahit" <?= ($this->input->get('kelolaan') == 'majapahit') ? 'selected' : '' ?>>Majapahit</option>
                    <option value="tlogosari" <?= ($this->input->get('kelolaan') == 'tlogosari') ? 'selected' : '' ?>>Tlogosari</option>
                </select>
            </div>
        </form>

        <!-- Judul -->
        <!-- Judul -->
        <h1 class="text-center fw-bold text-primary mb-0">DAFTAR ASET AGUNAN BRI BO SUDIARTO</h1>
        <p class="text-center text-dark mt-2 mb-5" style="line-height: 1.5; font-size: 1.2rem;">
            Lelang dan Non Lelang
        </p>

        <p class="text-center text-muted mb-4" style="font-size: 0.95rem;">
            <strong>Catatan:</strong> <em>Nilai limit</em> adalah nilai penawaran terendah dalam lelang, Nilai Limit akan di update secara berkala
        </p>

        <!-- Kartu Aset -->
        <div class="row row-cols-1 row-cols-md-3 g-4">
            <?php foreach ($lelang as $item): ?>
                <div class="col">
                    <div class="card shadow-sm h-100">
                        <img src="<?= base_url('uploads/' . $item['foto']) ?>" class="card-img-top" alt="Foto Rumah">
                        <div class="card-body">
                            <h5 class="card-title"><?= $item['nama_debitur'] ?></h5>
                            <p class="card-text"><?= word_limiter($item['deskripsi'], 20) ?></p> <br>
                            <h5 class="card-title">Nilai Limit : Rp <?= number_format($item['nilai_limit'], 0, ',', '.') ?></h5>
                        </div>
                        <div class="card-footer bg-white border-top">
                            <small class="text-muted">📞 <?= $item['contact_rm'] ?></small><br>
                            <small class="text-muted">📞 BO Brigjen Sudiarto (024) 6709917</small><br>
                            <small class="text-muted">🏦 <?= strtoupper($item['kelolaan']) ?> - BRI Brigjen Sudiarto</small>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Footer -->
        <div class="text-center mt-5 text-muted small">
            © <?= date('Y') ?> BRI Semarang Brigjen Sudiarto
        </div>
    </div>

</body>

</html>